//
//  ViewController.swift
//  AlternateIcon
//
//  Created by John Brayton on 6/19/25.
//

import UIKit

class ViewController: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        let button = UIButton()
        button.translatesAutoresizingMaskIntoConstraints = false
        button.setTitle("Change Icon", for: .normal)
        button.setTitleColor(.blue, for: .normal)
        button.addTarget(self, action: #selector(changeIcon(_:)), for: .touchUpInside)
        self.view.addSubview(button)
        self.view.addConstraints([
            button.centerXAnchor.constraint(equalTo: self.view.centerXAnchor),
            button.centerYAnchor.constraint(equalTo: self.view.centerYAnchor),
        ])
    }
    
    @objc func changeIcon( _: UIButton ) {
        print("got changeIcon(_:)")
        UIApplication.shared.setAlternateIconName("landmarks") { (error) in
            print("error: \(String(describing: error))")
        }
    }


}

